/*zapper*/
//g++ -o zapper zapper.cpp -I ../EzWindows/include -L/usr/X11R6/lib -lX11 -L../EzWindows/lib -lezwin
 
#include<iostream>
#include<cmath>
#include"ezwin.h"
#define TERRAIN 5
#define RADIUS 3
#define INFLUENCE 5 ;
using namespace std;

//declaring a window
SimpleWindow w("RAVINDRA",22.5,16,Position(0,5));

//using a timer to delay time
void timer(int seconds){
  clock_t endwait=clock()+(CLOCKS_PER_SEC*seconds)/100;
  while(clock()<endwait);
}

//distance function
float Distance(float x1,float y1,float x2,float y2){
  float D;
  D=(x1-x2)*(x1-x2)+(y1-y2)*(y1-y2);D=sqrt(D);
  return D;
}

//clear terrain
void clear(float x,float r,float terrain[2250]){
   float W=0.01;int i=x/W;float y1,y2,y0=terrain[i],c=-r;float terrain1[2250];
   for(i=(x-r)/W;i<(x+r)/W;i++)if(i>=0&&i<2250)terrain1[i]=terrain[i];
   for(i=(x-r)/W;i<(x+r)/W;i++){
     y1=y0-sqrt(r*r-c*c);
     y2=y0+sqrt(r*r-c*c);c+=0.01;
     if(i>=0&&i<2250&&terrain[i]>y1&&terrain[i]<y2)terrain[i]=y1;
     else if(i>=0&&i<2250&&terrain[i]>y2)terrain[i]-=y2-y1;
     if(terrain[i]<0)terrain[i]=0;
     w.RenderRectangle(Position(i*W,16-terrain1[i]),Position((i+1)*W,16-terrain[i]),Cyan,false);
     w.RenderRectangle(Position(i*W,16-terrain[i]),Position((i+1)*W,16),Green,false);
   }
}

/*bomb trajectory function*/
void zapper(float p,float q,float p2,float q2,float u,float A,float terrain[100],float *score){
  u=2*u;A=A*0.017453292; //converting u to CGS units and A to radians
  float W=0.01;float x=p,y=q;float r=0,Radius=1,t=0;int i=x/W;float D=Distance(p,q,p2,q2),I=5;
  while(x>=0&&x<22.5&&y>=terrain[i]){    
    y=q+u*sin(A)*t-490*t*t;
    x=p+u*cos(A)*t;i=x/W;
    w.RenderEllipse(Position(x,16-y),Position(x+0.1,16-y+.1),Red,false);
    timer(1);t+=0.0005; //using time delay function and increasing time
    w.RenderEllipse(Position(x,16-y),Position(x+0.1,16-y+.1),Cyan,false);
    D=Distance(x,y,p2,q2);
  
  
  if(D<I&&x<p2){
    p=x;q=y;
    t=(q2-q)/(p2-p);u=0.05;if(cos(A)<0)u=-0.05;
    while(D>0.1){
      y=q+(x-p)*t;x+=u;
      w.RenderLine(Position(p,16-q),Position(x,16-y),Red,0.005);timer(1);
      w.RenderLine(Position(p,16-q),Position(x,16-y),Cyan,0.005);
      D=Distance(x,y,p2,q2);
    }
    x=p2;y=q2;
    //scoring
    *score=*score+40;
    break;
  }
  }

  //explosion
  if(x>=0&&x<22.5){
    for(r=0;r<Radius;r+=.01){
      w.RenderEllipse(Position(x-r,16-y-r),Position(x+r,16-y+r),Yellow,false);
      timer(1);
    }
    w.RenderEllipse(Position(x-r,16-y-r),Position(x+r,16-y+r),Cyan,false);clear(x,Radius,terrain);
    D=Distance(x,y,p2,q2);
    //scoring
    if(D<Radius)*score=*score+40;
  }
}
    


//main program
int ApiMain(){  
  w.Open();
  //making terrain
  float W=0.01;int i=22.5/W;float terrain[i];float score;
  for(i=0;i<22.5/W;i++){terrain[i]=TERRAIN;}
  w.RenderRectangle(Position(0,16-TERRAIN),Position(22.5,16),Green,false);
  //making sky
  w.RenderRectangle(Position(0,0),Position(22.5,16-TERRAIN),Cyan,false);

  while(1){
    float x=1,p=1,y=5,q=5,p2=17,t=0,u=1,A=60,g=980,r=0;i=p2/W;float q2=terrain[i];
    w.RenderEllipse(Position(p2,16-q2),Position(p2+0.1,16-q2+.1),Red,false);
    cout<<"Enter Intial Co-ordinates(p,q) in cm: "; 
    cout<<"Enter Intial Velocity(u) in m/sec: "; cin>>u;
    cout<<"Enter Angle of projection(A) of missile in degrees: "; cin>>A;
    zapper(p,q,p2,q2,u,A,terrain,&score);
  }
  return 0;
}
